#include <winsock.h>
#include <stdio.h>
#include <memory.h>
#include <string.h>

#define MAX_TIMEOUT_SECONDS			6
#define MAX_TIMEOUT_MILLISECONDS		230000

#define SUCCESS 0

int sosCleanup( SOCKET *pSocket );
int sosConnect( SOCKET *pSocket, char *pAddress, int pPort );
int sosSend( SOCKET *pSocket, const char* pBuffer, int pSize );
int sosRecv( SOCKET *pSocket, const char* pBuffer, int pSize );
int sosStartup( void );

void main( void )
{
	SOCKET pSocket = INVALID_SOCKET;

	char	teste[10] = "TESTE";

        printf( "Inicio\n" );

	if( sosStartup() )
	{
                printf( "Erro em Startup\n" );
		return;
	}

        printf( "sosStartup Ok\n" );

	if( sosConnect( &pSocket, "192.168.5.1", 1234 ) )
	{
                printf( "Erro em connect\n" );
		return;
	}

        printf( "sosConnect Ok socket = %d\n", pSocket );

	if( sosSend( &pSocket, teste, strlen(teste) ) )
	{
		printf( "Erro no envio\n" );
		sosCleanup( &pSocket );
		return;
	}

        printf( "sosSend Ok" );

	memset( teste, 0, sizeof(teste) );

	if( !sosRecv( &pSocket, teste, sizeof(teste)-1 ) )
	{
		printf( "Erro no receive\n" );
	}
	else
	{
		printf( "teste = %s\n", teste );
	}

	sosCleanup( &pSocket );
}


int sosStartup( void )
{
	WORD wVersionRequested;
	WSADATA wsaData;
	int err;

	wVersionRequested = MAKEWORD( 1, 1 );
	
	err = WSAStartup( wVersionRequested, &wsaData );
	
	if( err != 0 ) 
	{
		return err;
	}

	if( LOBYTE( wsaData.wVersion ) != 1 || HIBYTE( wsaData.wVersion ) != 1 )
	{
      WSACleanup();
      return WSAVERNOTSUPPORTED;
  }

	if(	LOBYTE( wVersionRequested ) < 1 ||
			( LOBYTE( wVersionRequested ) == 1 && HIBYTE( wVersionRequested ) < 1 ) )
	{
		WSACleanup( );
		return WSAEINVAL;
	}

	return SUCCESS;
}

int sosCleanup( SOCKET *pSocket )
{
	if( *pSocket && *pSocket != INVALID_SOCKET )
	{
		shutdown( *pSocket, 2 );
		closesocket( *pSocket );
	}

	return WSACleanup();
}

int sosConnect( SOCKET *pSocket, char *pAddress, int pPort )
{
	struct sockaddr_in sa_dest;

	*pSocket = socket( AF_INET, SOCK_STREAM, 0 );

	if( *pSocket == INVALID_SOCKET )
	{
            return INVALID_SOCKET;
	}

	sa_dest.sin_family = AF_INET;
	sa_dest.sin_addr.s_addr = inet_addr(pAddress);
	sa_dest.sin_port = htons( pPort );

	return connect( *pSocket, (struct sockaddr *)&sa_dest, (int)sizeof(struct sockaddr) );
}


int sosSend( SOCKET *pSocket, const char* pBuffer, int pSize )
{
	struct timeval	Timeout;

	fd_set	writefds;

	int     Select = 0;
	
	Timeout.tv_sec  = MAX_TIMEOUT_SECONDS;
	Timeout.tv_usec = MAX_TIMEOUT_MILLISECONDS;

	FD_ZERO( &writefds );
	FD_SET( *pSocket, &writefds );

        printf( "Select em socket %d\n", *pSocket );

	Select = select( *pSocket, NULL, &writefds, NULL, &Timeout );

        printf( "select = %d\n", Select );

	if( Select == 0 )
	{
		return WSAETIMEDOUT;
	}

	if( Select < 0 )
	{
		return Select;
	}

	Select = send( *pSocket, pBuffer, pSize, 0 );

	if( Select == pSize )
	{
		return SUCCESS;
	}

	return Select;
}


int sosRecv( SOCKET *pSocket, const char *pBuffer, int pSize )
{
	fd_set	readfds;

	unsigned char	mAuxData[4096];
	
	int	Bytes		= 0,
			Offset	= 0,
			Select	= 0,
			Total   = 0;
	
	struct timeval Timeout;

	Timeout.tv_sec  = MAX_TIMEOUT_SECONDS;
	Timeout.tv_usec = MAX_TIMEOUT_MILLISECONDS;

	memset( mAuxData, 0, sizeof(mAuxData) );

	while( 1 )
	{
		FD_ZERO( &readfds );
		FD_SET( *pSocket, &readfds );

		Select= select( *pSocket, &readfds, NULL, NULL, &Timeout );

		if( Select > 0 )
		{
			memset( mAuxData, 0, sizeof(mAuxData) );

			Bytes = recv( *pSocket, (char *)mAuxData, (int)sizeof(mAuxData)-(int)(sizeof(char) * 1 ), 0 );

			if( Total + Bytes > pSize )
			{
				return Total;
			}

			if( Bytes > 0 )
			{
				memcpy( (char *)(pBuffer+Offset), (char *)mAuxData, Bytes );
				Offset += Bytes;
				Total += Bytes;
			}
			else
			{
				return Total;
			}
		}
		else
		{
			return Total;
		}

		Timeout.tv_sec = 0;
	}
	
	return Total;
}


